@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary scrolled">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
                @if (!empty(Auth::user()->SetCidade->nome))
                    {{ Auth::user()->SetCidade->nome }}-{{ Auth::user()->SetEstado->uf }}
                @else
                    Menu
                @endif
                {{-- <ion-icon name="chevron-down-outline"></ion-icon> --}}
            </a>
        </div>
        <div class="pageTitle">

        </div>
        <div class="right">
            {{-- <a href="javascript:;" class="headerButton toggle-searchbox">
                <ion-icon name="search-outline"></ion-icon>
            </a> --}}
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- Search Component -->
    <div id="search" class="appHeader">
        <form class="search-form">
            <div class="form-group searchbox">
                <input id="s" type="text" class="form-control" placeholder="Qual serviço esta precisando?">
                <i class="input-icon">
                    <ion-icon name="search-outline"></ion-icon>
                </i>
                <a id="close-searchbox" href="javascript:;" class="ml-1 close toggle-searchbox">
                    <ion-icon name="close-circle"></ion-icon>
                </a>
            </div>
        </form>
    </div>
    <!-- * Search Component -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div id="result"></div>
        <div class="header-large-title">
            <h1 class="title">Olá {{ !empty(Auth::user()->name) ? Auth::user()->name : 'visitante' }}</h1>
            <h4 class="subtitle">Como podemos te ajudar hoje?</h4>
        </div>

        <div class="section full mt-3 mb-3">
            <div class="carousel-multiple owl-carousel owl-theme">
                @foreach ($categorias as $categoria)
                    <div class="item center">
                        <a href="{{ route('app.anuncios.categoria', $categoria->id) }}">
                            <img src="{{ url("storage/{$categoria->ico}") }}" class="card-img-top" alt="image">
                        </a>
                        <div class="card-body pt-2">
                            <a href="{{ route('app.anuncios.categoria', $categoria->id) }}">
                                <h4 class="mb-0">{{ $categoria->titulo }}</h4>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="section full mb-3">
            <div class="carousel-single owl-carousel owl-theme">
                <div class="item">
                    <a href="http://garimpow.com.br/anuncios/33/349">
                        <img src="http://garimpow.com.br/storage/slides/regrigeracao1184298052.jpg" alt="alt"
                            class="imaged w-100">
                    </a>
                </div>
                <div class="item">
                    <a href="http://garimpow.com.br/anuncios/46/237">
                        <img src="http://garimpow.com.br/storage/slides/odontologia1603142054.jpg" alt="alt"
                            class="imaged w-100">
                    </a>
                </div>
                <div class="item">
                    <a href="http://garimpow.com.br/anuncios/50/350">
                        <img src="http://garimpow.com.br/storage/slides/advogados1654427310.jpg" alt="alt"
                            class="imaged w-100">
                    </a>
                </div>
                <div class="item">
                    <a href="http://garimpow.com.br/anuncios/50/351">
                        <img src="http://garimpow.com.br/storage/slides/programadores1412886425.png" alt="alt"
                            class="imaged w-100">
                    </a>
                </div>
            </div>
        </div>
        <div class="listview-title mt-2">
            <h3 class="text-primary">Destaques Chibarro Grei</h3>
            <h4 class="text-primary"><a href="{{ route('app.categorias') }}">Ver Todos</a></h4>
        </div>
        <ul class="listview image-listview media search-result mb-2" id="result">
            @foreach ($anuncios as $anuncio)
            <li>
                <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                    @if (!empty($anuncio->thumb))
                        <div class="imageWrapper">
                            <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                        </div>
                    @endif
                    <div class="in">
                        <div>
                            <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                            <div class="text-muted">
                                {{@$anuncio->categoria->titulo}} {{!empty($anuncio->sub) ? '- '.$anuncio->sub->titulo : ''}}<br>
                                {{!empty($anuncio->bairro) ? $anuncio->bairro.', ': ''}} {{$anuncio->cidade}}-{{$anuncio->estado}}
                                <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                             </div>
                        </div>
                    </div>
                </a>
            </li>
            @endforeach
        </ul>
        <div class="listview-title mt-2">
            <h3 class="text-primary">Como funciona?</h3>
        </div>
        <div class="section carousel-full owl-carousel owl-theme mt-3 mb-3">
            <div class="card">
                <div class="item">
                    <img src="http://garimpow.com.br/app/assets/img/vector1.png" alt="alt"
                        class="imaged w-100 square">
                    <div class="card-body">
                        <h4>Conte o que precisa</h4>
                        <p>Conte o que precisa, inclua o máximo de detalhes, se puder inclua fotos para receber
                            orçamentos mais precisos.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="item">
                    <img src="http://garimpow.com.br/app/assets/img/vector2.png" alt="alt"
                        class="imaged w-100 square">
                    <div class="card-body">
                        <h4>Conte o que precisa</h4>
                        <p>Conte o que precisa, inclua o máximo de detalhes, se puder inclua fotos para receber
                            orçamentos mais precisos.</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="item">
                    <img src="http://garimpow.com.br/app/assets/img/vector3.png" alt="alt"
                        class="imaged w-100 square">
                    <div class="card-body">
                        <h4>Conte o que precisa</h4>
                        <p>Conte o que precisa, inclua o máximo de detalhes, se puder inclua fotos para receber
                            orçamentos mais precisos.</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="appFooter">
            <img src="{{ url('adm') }}/assets/images/logo.png" alt="icon">
            <div class="footer-title">
                (16) 99732-2886 | (16) 99992-2886
            </div>
            Rede Maçônica Comercial - Conectando Irmãos - Tudo isso centralizado
            <div class="mt-2">
                <a href="tel:16997322886" class="btn btn-icon btn-sm btn-facebook">
                    <ion-icon name="call-outline"></ion-icon>
                </a>
                <a href="tel:169999922886" class="btn btn-icon btn-sm btn-facebook">
                    <ion-icon name="call-outline"></ion-icon>
                </a>
                <a href="javascript:;" class="btn btn-icon btn-sm btn-instagram">
                    <ion-icon name="logo-instagram"></ion-icon>
                </a>
                <a href="javascript:;" class="btn btn-icon btn-sm btn-whatsapp">
                    <ion-icon name="logo-whatsapp"></ion-icon>
                </a>
                <a href="javascript:;" class="btn btn-icon btn-sm btn-whatsapp">
                    <ion-icon name="logo-whatsapp"></ion-icon>
                </a>
            </div>
        </div>

    </div>
    <!-- * App Capsule -->
@endsection
@section('js')
    <script>

    </script>
@endsection
